-- We're gonna do some trickery here from the metrics
-- so top grades can be shown next to each chart!
return Def.ActorFrame {
	-- Base stuff.
	Def.Quad {
		OnCommand=function(self)
			self:zoomto(240,18):diffuse(ColorBlend(LocalBlueColor(0), Color.Black))
		end
	},
	LoadActor("_frameEdge") .. {
		OnCommand=function(self)
			self:x(86)
		end
	},
	
	-- Decorative colorful stuff.
	LoadActor("_frameCap") .. {
		Name="FrameSide1",
		OnCommand=function(self)
			self:x(-116)
		end
	},
	LoadActor("_frameCap") .. {
		Name="FrameSide2",
		OnCommand=function(self)
			self:x(116):rotationz(180)
		end
	},
	
	-- Grades!
	Def.BitmapText {
		Name="GradeP1",
		Font="Common Normal",
		OnCommand=function(self)
			self:x(-116):zoom(0.45):strokecolor(Color.Black)
		end
	},
	Def.BitmapText {
		Name="GradeP2",
		Font="Common Normal",
		OnCommand=function(self)
			self:x(116):zoom(0.45):strokecolor(Color.Black)
		end
	},
	
	-- Difficulty rating.
	Def.BitmapText {
		Name="Meter",
		Font="Common Normal",
		OnCommand=function(self)
			self:x(86):zoom(0.6):maxwidth(26/0.6)
		end
	},
	-- StepsType display.
	Def.BitmapText {
		Name="StepsType",
		Condition = ShowStepsTypeOnStepsList(),
		Font="Common Normal",
		OnCommand=function(self)
			self:horizalign(left):xy(-94,-6):zoom(0.25):maxwidth(130):uppercase(true)
		end
	},
	-- Description AKA chart title..
	Def.BitmapText {
		Name="Description",
		Font="Common Normal",
		OnCommand=function(self)
			self:horizalign(left):xy(-94,ShowStepsTypeOnStepsList() and 4 or 0):zoom(ShowStepsTypeOnStepsList() and 0.4 or 0.5):maxwidth(156/0.5):uppercase(true)
		end
	},
}
